<?php
//about theme info
add_action( 'admin_menu', 'skt_camping_abouttheme' );
function skt_camping_abouttheme() {    	
	add_theme_page( esc_html__('About Theme', 'skt-camping'), esc_html__('About Theme', 'skt-camping'), 'edit_theme_options', 'skt_camping_guide', 'skt_camping_mostrar_guide');   
} 
//guidline for about theme
function skt_camping_mostrar_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
?>
<div class="wrapper-info">
	<div class="col-left">
   		   <div class="col-left-area">
			  <?php esc_html_e('Theme Information', 'skt-camping'); ?>
		   </div>
          <p><?php esc_html_e('The SKT Camping WordPress theme is responsive. Crafted for those who thrive on exploration and the thrill of outdoor escapades. Perfect for promoting adventures like backpacking journeys, wilderness camping, and hiking treks, this theme beautifully showcases every aspect of outdoor living. Ideal for organizing expeditions, nature excursions, or camping trips, it offers a highly flexible, scalable, and fully editable framework. Whether your site focuses on capturing the thrill of an odyssey, the excitement of a quest, or the essence of a venture into nature, SKT Camping equips you with everything needed to create an engaging online presence for every outdoor adventure.','skt-camping'); ?></p>
          <a href="<?php echo esc_url(SKT_CAMPING_SKTTHEMES_PRO_THEME_URL); ?>"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/free-vs-pro.png" alt="<?php esc_attr_e('Free Vs Pro', 'skt-camping'); ?>" /></a>
	</div><!-- .col-left -->
	<div class="col-right">			
			<div class="centerbold">
				<hr />
				<a href="<?php echo esc_url(SKT_CAMPING_SKTTHEMES_LIVE_DEMO); ?>" target="_blank"><?php esc_html_e('Live Demo', 'skt-camping'); ?></a> | 
				<a href="<?php echo esc_url(SKT_CAMPING_SKTTHEMES_PRO_THEME_URL); ?>"><?php esc_html_e('Buy Pro', 'skt-camping'); ?></a> | 
				<a href="<?php echo esc_url(SKT_CAMPING_SKTTHEMES_THEME_DOC); ?>" target="_blank"><?php esc_html_e('Documentation', 'skt-camping'); ?></a>
                <div class="space5"></div>
				<hr />                
                <a href="<?php echo esc_url(SKT_CAMPING_SKTTHEMES_THEMES); ?>" target="_blank"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/sktskill.jpg" alt="<?php esc_attr_e('SKT Themes', 'skt-camping'); ?>" /></a>
			</div>		
	</div><!-- .col-right -->
</div><!-- .wrapper-info -->
<?php } ?>